---
title: 智慧CA OSSAPI接口文档
type: api
order: 1000
---

## 说明
演示环境webservice地址：http://webs.ca.demo.smartcert.cn/services/userAPI?wsdl

**一、公共参数**

| 名称 | 类型 | 是否必须 | 描述 |
| :-: |  :-: |  :-: |  :- |
| accountHash | String | 是 | 固定值：1F2C2B234E494266FBC3 |
| certReqChallenge | String | 是 | 固定值：SmartCA  |
| aaCheckPoint | String | 是 | 固定值：SmartCA |



## 接口描述

### 证书申请

根据pkcs10请求进行证书申请接口

**二、请求参数**

| 名称 | 类型 | 是否必须 | 描述 |
| :-: |  :-: |  :-: |  :- |
| certReqBuf | String | 是 | pkcs10标准的证书请求（CSR） |
| UserInfo | UserInfo | 是 | 用户信息 |


**代码实例**

```java
public class EnrollCert {

    private static String webserviceUrl = "http://webs.ca.demo.smartcert.cn/services/userAPI?wsdl";// 接口地址配置
    private static String accountHash = "1F2C2B234E494266FBC3";
    private static String aaCheckPoint = "SmartCA";
    private static String passCode = "SmartCA";
    private static String json = "";

    public static void main(String[] args) {
        try {
            String certReqBuf = "MIHcMIGBAgEAMCExEjAQBgNVBAMMCeeOi+Wwj+W8ujELMAkGA1UEBhMCY24wWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAASKv9E0tmrl6gS6tTWRhPtGbFbfySDcrUc+gcXSofjyxtupXZz0rD+kJUH6qszBenyyc147jo+sZbdAQdUF+08bMAwGCCqBHM9VAYN1BQADSAAwRQIgWpTtcqraZ17qxrV4yMBGBc3dWX4Zjppl6ns/z0ocxrUCIQDMfSLFmVPIVD+lb5a6rWFB1wNSCah0daayzVwcUn0DZw==";
            UserInfo userInfo = new UserInfo();
            userInfo.setUserName("王小强");
            userInfo.setUserSerialnumber("142729199807093316");
            UserAPIServicePortTypeProxy proxy = new UserAPIServicePortTypeProxy();
            proxy.setEndpoint(webserviceUrl);
            CertInfo certInfo = proxy.enrollCertAA(userInfo, certReqBuf, accountHash, aaCheckPoint, passCode, json);
            System.out.println("当前申请的证书序列号是：[" + certInfo.getCertSerialNumber() + "]");
            System.out.println("当前申请的证书公钥：[" + certInfo.getCertSignBuf() + "]");
            System.out.println("证书有效期：[" + certInfo.getCertNotBefore() + " ~ " + certInfo.getCertNotAfter() + "]");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
```


**三、响应参数**


- 返回值[CertInfo](CertInfo)说明

| 字段名称 | 描述 |
| :-: | :- |
| certStatus | 状态 |
| certReqDate | 请求时间 |
| certSignDate | 签发时间 |
| certSerialNumber | 证书唯一序列号 |
| certNotBefore | 有效期起 |
| certNotAfter | 有效期止 |
| certSignBuf | 签发后的公钥证书信息 |
| certSubjectDn | 证书主题 |

### 吊销证书

根据证书序列化进行吊销接口

**二、请求参数**

| 名称 | 类型 | 是否必须 | 描述 |
| :-: |  :-: |  :-: |  :- |
| serialNumber | String | 是 | 待被吊销的证书序列号 |


**代码实例**

```java
public class RevokeCert {
    private static String webserviceUrl = "http://webs.ca.demo.smartcert.cn/services/userAPI?wsdl";// 接口地址配置
    private static String accountHash = "1F2C2B234E494266FBC3";
    private static String aaCheckPoint = "SmartCA";
    private static String passCode = "SmartCA";
    private static String json = "";

    public static void main(String[] args) {
        try {
            UserAPIServicePortTypeProxy proxy = new UserAPIServicePortTypeProxy();
            proxy.setEndpoint(webserviceUrl);
            String serialNumber = "2020121800504669";
            proxy.revokeCert(serialNumber, aaCheckPoint, "", accountHash, json);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
```


**三、响应参数**

不返回任何值,失败则抛出异常

### 延期证书

根据原证书序列化或者原证书信息进行证书延期接口

**二、请求参数**

| 名称 | 类型 | 是否必须 | 描述 |
| :-: |  :-: |  :-: |  :- |
| CertInfo.serialNumber | String | 否 | 待延期的证书序列号 |
|  CertInfo.CertSignBuf | String | 是 | 待延期的证书信息 |

**代码实例**

```java
public class UpdateCert {

    private static String webserviceUrl = "http://webs.ca.demo.smartcert.cn/services/userAPI?wsdl";// 接口地址配置
    private static String accountHash = "1F2C2B234E494266FBC3";
    private static String aaCheckPoint = "SmartCA";
    private static String passCode = "SmartCA";
    private static String json = "";

    public static void main(String[] args) {
        try {
            UserAPIServicePortTypeProxy proxy = new UserAPIServicePortTypeProxy();
            proxy.setEndpoint(webserviceUrl);
            UserInfo userInfo = new UserInfo();
            CertInfo oragin = new CertInfo();
            //oragin.setCertSerialNumber("2020121800504669");
            oragin.setCertSignBuf("MIICijCCAjGgAwIBAgIIICASGABQRmkwCgYIKoEcz1UBg3UwdjEcMBoGA1UEAwwTU21hcnRDQV9UZXN0X1NNMl9DQTEVMBMGA1UECwwMU21hcnRDQV9UZXN0MRAwDgYDVQQKDAdTbWFydENBMQ8wDQYDVQQHDAbljZfkuqwxDzANBgNVBAgMBuaxn+iLjzELMAkGA1UEBhMCQ04wHhcNMjAxMjE4MDgwMDQ0WhcNMjExMjE4MDgwMDQ0WjCBnDEwMC4GA1UELQwnNGQxYWU0NGI5NTA1NGMxOGFhMzE5MWViZDE0MGVlNTMyMDIwMTIxMQswCQYDVQQGEwJDTjEPMA0GA1UECAwG5rGf6IuPMQ8wDQYDVQQHDAbljZfkuqwxEDAOBgNVBAoMB1NtYXJ0Q2ExETAPBgNVBAsMCOm7mOiupE9VMRQwEgYDVQQDDAvnjovlsI/lvLpAMzBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABIq/0TS2auXqBLq1NZGE+0ZsVt/JINytRz6BxdKh+PLG26ldnPSsP6QlQfqqzMF6fLJzXjuOj6xlt0BB1QX7TxujgYEwfzALBgNVHQ8EBAMCBsAwHQYDVR0OBBYEFG62KqVkixphP8D0WG0IjfT/Zh0fMB8GA1UdIwQYMBaAFFzzuiWMwmUM7Gfvvt2Na6der+OsMAwGA1UdEwQFMAMBAf8wIgYIKoEc0BQEAQEEFqAUExIxNDI3MjkxOTk4MDcwOTMzMTYwCgYIKoEcz1UBg3UDRwAwRAIgZY+jE+bJCcPiUKVb14tBiVfULd6P6O8+8uKaxkiU+h0CIC5Bm9HECMBYW8qZi4Iaf8UZOySIELQb0v+NdD8B2nKc");
            CertInfo certInfo = proxy.renewCertAA(userInfo, oragin, accountHash, aaCheckPoint, "123456", json);
            System.out.println("当前申请的证书序列号是：[" + certInfo.getCertSerialNumber() + "]");
            System.out.println("当前申请的证书公钥：[" + certInfo.getCertSignBuf() + "]");
            System.out.println("证书有效期：[" + certInfo.getCertNotBefore() + " ~ " + certInfo.getCertNotAfter() + "]");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}

```


**三、响应参数**


- 返回值[CertInfo](CertInfo)说明

| 字段名称 | 描述 |
| :-: | :- |
| certStatus | 状态 |
| certReqDate | 请求时间 |
| certSignDate | 签发时间 |
| certSerialNumber | 证书唯一序列号 |
| certNotBefore | 有效期起 |
| certNotAfter | 有效期止 |
| certSignBuf | 签发后的公钥证书信息 |
| certSubjectDn | 证书主题 |